/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.algorithm.multi.FASK;
import edu.cmu.tetrad.algcomparison.algorithm.multi.ImagesSemBic;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Algorithm;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Algorithm(name="FASK-Vote", command="fask-vote", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.Continuous})
@Bootstrapping
public class FaskVote
implements MultiDataSetAlgorithm,
HasKnowledge,
UsesScoreWrapper,
TakesIndependenceWrapper {
    static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();
    private ScoreWrapper score;
    private IndependenceWrapper test;

    public FaskVote() {
    }

    public FaskVote(IndependenceWrapper test, ScoreWrapper score) {
        this.test = test;
        this.score = score;
    }

    @Override
    public Graph search(List<DataModel> dataSets, Parameters parameters) {
        for (DataModel dataModel : dataSets) {
            if (!((DataSet)dataModel).existsMissingValue()) continue;
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        if (parameters.getInt("numberResampling") < 1) {
            ArrayList<DataSet> _dataSets = new ArrayList<DataSet>();
            for (DataModel d : dataSets) {
                _dataSets.add((DataSet)d);
            }
            edu.cmu.tetrad.search.FaskVote faskVote = new edu.cmu.tetrad.search.FaskVote(_dataSets, this.score, this.test);
            faskVote.setKnowledge(this.knowledge);
            return faskVote.search(parameters);
        }
        FaskVote imagesSemBic = new FaskVote(this.test, this.score);
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataModel dataModel : dataSets) {
            arrayList.add((DataSet)dataModel);
        }
        GeneralResamplingTest search = new GeneralResamplingTest(arrayList, imagesSemBic, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(this.score);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet)), parameters);
        }
        FaskVote imagesSemBic = new FaskVote();
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, imagesSemBic, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(this.score);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "FASK-Vote";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        List<String> parameters = new ImagesSemBic().getParameters();
        parameters.addAll(new FASK().getParameters());
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper independenceWrapper) {
        this.test = independenceWrapper;
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }
}

