/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Bootstrapping
public class FgesConcatenated
implements MultiDataSetAlgorithm,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private final ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();
    private Algorithm externalGraph;
    private boolean compareToTrue;

    public FgesConcatenated(ScoreWrapper score) {
        this.score = score;
    }

    public FgesConcatenated(ScoreWrapper score, boolean compareToTrue) {
        this.score = score;
        this.compareToTrue = compareToTrue;
    }

    public FgesConcatenated(ScoreWrapper score, Algorithm externalGraph) {
        this.score = score;
        this.externalGraph = externalGraph;
    }

    @Override
    public Graph search(List<DataModel> dataModels, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
            for (DataModel dataModel : dataModels) {
                dataSets.add((DataSet)dataModel);
            }
            DataSet dataSet = DataUtils.concatenate(dataSets);
            Graph initial = null;
            if (this.externalGraph != null) {
                initial = this.externalGraph.search(dataSet, parameters);
            }
            Fges search = new Fges(this.score.getScore(dataSet, parameters));
            search.setKnowledge(this.knowledge);
            search.setVerbose(parameters.getBoolean("verbose"));
            search.setMaxDegree(parameters.getInt("maxDegree"));
            Object obj = parameters.get("printStedu.cmream");
            if (obj instanceof PrintStream) {
                search.setOut((PrintStream)obj);
            }
            if (initial != null) {
                search.setBoundGraph(initial);
            }
            return search.search();
        }
        FgesConcatenated fgesConcatenated = new FgesConcatenated(this.score, this.externalGraph);
        fgesConcatenated.setCompareToTrue(this.compareToTrue);
        ArrayList<DataSet> datasets = new ArrayList<DataSet>();
        for (DataModel dataModel : dataModels) {
            datasets.add((DataSet)dataModel);
        }
        GeneralResamplingTest search = new GeneralResamplingTest(datasets, fgesConcatenated, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(this.score);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet)), parameters);
        }
        FgesConcatenated fgesConcatenated = new FgesConcatenated(this.score, this.externalGraph);
        fgesConcatenated.setCompareToTrue(this.compareToTrue);
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, fgesConcatenated, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(this.score);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        if (this.compareToTrue) {
            return new EdgeListGraph(graph);
        }
        return SearchGraphUtils.cpdagForDag(new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "FGES (Fast Greedy Equivalence Search) on concatenated data using " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("faithfulnessAssumed");
        parameters.add("maxDegree");
        parameters.add("numRuns");
        parameters.add("randomSelectionSize");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setCompareToTrue(boolean compareToTrue) {
        this.compareToTrue = compareToTrue;
    }
}

