/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.score.BdeuScore;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.BdeuScoreImages;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@Bootstrapping
@Experimental
public class ImagesBDeu
implements MultiDataSetAlgorithm,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();

    @Override
    public Graph search(List<DataModel> dataSets, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            BdeuScoreImages score = new BdeuScoreImages(dataSets);
            score.setSamplePrior(parameters.getDouble("priorEquivalentSampleSize"));
            score.setStructurePrior(parameters.getDouble("structurePrior"));
            Fges search = new Fges(score);
            search.setFaithfulnessAssumed(true);
            search.setKnowledge(this.knowledge);
            search.setVerbose(parameters.getBoolean("verbose"));
            return search.search();
        }
        ImagesBDeu imagesBDeu = new ImagesBDeu();
        ArrayList<DataSet> datasets = new ArrayList<DataSet>();
        for (DataModel dataModel : dataSets) {
            datasets.add((DataSet)dataModel);
        }
        GeneralResamplingTest search = new GeneralResamplingTest(datasets, imagesBDeu, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(null);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getDiscreteDataSet(dataSet)), parameters);
        }
        ImagesBDeu imagesBDeu = new ImagesBDeu();
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, imagesBDeu, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(null);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.cpdagForDag(new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "IMaGES for discrete variables (using the BDeu score)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Discrete;
    }

    @Override
    public List<String> getParameters() {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.addAll(new edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges().getParameters());
        parameters.addAll(new BdeuScore().getParameters());
        parameters.add("numRuns");
        parameters.add("randomSelectionSize");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

