/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SemBicScoreImages;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@Bootstrapping
@Experimental
public class ImagesSemBic
implements MultiDataSetAlgorithm,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();

    @Override
    public Graph search(List<DataModel> dataSets, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            ArrayList<DataModel> _dataSets = new ArrayList<DataModel>();
            if (parameters.getInt("timeLag") > 0) {
                for (DataModel dataSet : dataSets) {
                    DataSet dataSet2 = TimeSeriesUtils.createLagData((DataSet)dataSet, parameters.getInt("timeLag"));
                    if (dataSet.getName() != null) {
                        dataSet2.setName(dataSet.getName());
                    }
                    _dataSets.add(dataSet2);
                }
                dataSets = _dataSets;
                this.knowledge = ((DataModel)_dataSets.get(0)).getKnowledge();
            }
            SemBicScoreImages score = new SemBicScoreImages(dataSets);
            score.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
            Fges search = new Fges(score);
            search.setKnowledge(this.knowledge);
            search.setVerbose(parameters.getBoolean("verbose"));
            return search.search();
        }
        ImagesSemBic imagesSemBic = new ImagesSemBic();
        ArrayList<DataSet> dataSets2 = new ArrayList<DataSet>();
        for (DataModel dataModel : dataSets) {
            dataSets2.add((DataSet)dataModel);
        }
        ArrayList<DataSet> _dataSets = new ArrayList<DataSet>();
        if (parameters.getInt("timeLag") > 0) {
            for (DataModel dataModel : dataSets2) {
                DataSet timeSeries = TimeSeriesUtils.createLagData((DataSet)dataModel, parameters.getInt("timeLag"));
                if (dataModel.getName() != null) {
                    timeSeries.setName(dataModel.getName());
                }
                _dataSets.add(timeSeries);
            }
            dataSets2 = _dataSets;
            this.knowledge = ((DataSet)_dataSets.get(0)).getKnowledge();
        }
        GeneralResamplingTest generalResamplingTest = new GeneralResamplingTest(dataSets2, imagesSemBic, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        generalResamplingTest.setKnowledge(this.knowledge);
        generalResamplingTest.setScoreWrapper(null);
        generalResamplingTest.setParameters(parameters);
        generalResamplingTest.setVerbose(parameters.getBoolean("verbose"));
        generalResamplingTest.setKnowledge(this.knowledge);
        return generalResamplingTest.search();
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet)), parameters);
        }
        ImagesSemBic imagesSemBic = new ImagesSemBic();
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, imagesSemBic, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(null);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "IMaGES for continuous variables (using the SEM BIC score)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.addAll(new SemBicScore().getParameters());
        parameters.addAll(new edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges().getParameters());
        parameters.add("penaltyDiscount");
        parameters.add("randomSelectionSize");
        parameters.add("timeLag");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

