/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.SemBicScoreMultiFas;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@Bootstrapping
public class MultiFaskV1
implements MultiDataSetAlgorithm,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();

    @Override
    public Graph search(List<DataModel> dataSets, Parameters parameters) {
        Object search;
        for (DataModel dataModel : dataSets) {
            DataSet _data = (DataSet)dataModel;
            for (int j = 0; j < _data.getNumColumns(); ++j) {
                for (int i = 0; i < _data.getNumRows(); ++i) {
                    if (!Double.isNaN(_data.getDouble(i, j))) continue;
                    throw new IllegalArgumentException("Please remove or impute missing values.");
                }
            }
        }
        if (parameters.getInt("numberResampling") < 1) {
            ArrayList<DataSet> _dataSets = new ArrayList<DataSet>();
            for (DataModel d : dataSets) {
                _dataSets.add((DataSet)d);
            }
            SemBicScoreMultiFas semBicScoreMultiFas = new SemBicScoreMultiFas(dataSets);
            semBicScoreMultiFas.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
            search = new edu.cmu.tetrad.search.MultiFaskV1(_dataSets, semBicScoreMultiFas);
            ((edu.cmu.tetrad.search.MultiFaskV1)search).setKnowledge(this.knowledge);
            return ((edu.cmu.tetrad.search.MultiFaskV1)search).search();
        }
        MultiFaskV1 imagesSemBic = new MultiFaskV1();
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataModel dataModel : dataSets) {
            arrayList.add((DataSet)dataModel);
        }
        search = new GeneralResamplingTest(arrayList, imagesSemBic, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        ((GeneralResamplingTest)search).setKnowledge(this.knowledge);
        ((GeneralResamplingTest)search).setScoreWrapper(null);
        ((GeneralResamplingTest)search).setParameters(parameters);
        ((GeneralResamplingTest)search).setVerbose(parameters.getBoolean("verbose"));
        return ((GeneralResamplingTest)search).search();
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            return this.search(Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet)), parameters);
        }
        MultiFaskV1 imagesSemBic = new MultiFaskV1();
        List<DataSet> dataSets = Collections.singletonList(SimpleDataLoader.getContinuousDataSet(dataSet));
        GeneralResamplingTest search = new GeneralResamplingTest(dataSets, imagesSemBic, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setScoreWrapper(null);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "IMaGES for continuous variables (using the SEM BIC score)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.addAll(new Fges().getParameters());
        parameters.addAll(new SemBicScore().getParameters());
        parameters.add("numRuns");
        parameters.add("randomSelectionSize");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

