/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.BossDC;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Bootstrapping
@Experimental
public class BOSSDC
implements Algorithm,
UsesScoreWrapper {
    static final long serialVersionUID = 23L;
    private ScoreWrapper score;

    public BOSSDC() {
    }

    public BOSSDC(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        Score score = this.score.getScore(dataModel, parameters);
        BossDC boss = new BossDC(score);
        if (parameters.getInt("bossAlg") == 1) {
            boss.setAlgType(Boss.AlgType.BOSS1);
        } else if (parameters.getInt("bossAlg") == 2) {
            boss.setAlgType(Boss.AlgType.BOSS2);
        } else if (parameters.getInt("bossAlg") == 3) {
            boss.setAlgType(Boss.AlgType.BOSS3);
        } else {
            throw new IllegalArgumentException("Unrecognized boss algorithm type.");
        }
        boss.setDepth(parameters.getInt("depth"));
        boss.setUseDataOrder(parameters.getBoolean("graspUseDataOrder"));
        boss.setVerbose(parameters.getBoolean("verbose"));
        boss.setNumStarts(parameters.getInt("numStarts"));
        boss.setCaching(parameters.getBoolean("cacheScores"));
        boss.bestOrder(new ArrayList<Node>(score.getVariables()));
        return boss.getGraph(true);
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "BOSSDC (Best Order Score Search Divide and Conquer) using " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("graspUseDataOrder");
        params.add("cacheScores");
        params.add("verbose");
        params.add("bossAlg");
        params.add("numStarts");
        params.add("depth");
        return params;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }
}

