/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.BossMB;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@Bootstrapping
@Experimental
public class BOSS_MB
implements Algorithm,
HasKnowledge,
UsesScoreWrapper {
    static final long serialVersionUID = 23L;
    private ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();
    private String targets;

    public BOSS_MB() {
    }

    public BOSS_MB(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            this.targets = parameters.getString("targets");
            String[] tokens = this.targets.split(",");
            ArrayList<Node> targets = new ArrayList<Node>();
            Score score = this.score.getScore(dataSet, parameters);
            for (String t : tokens) {
                String name = t.trim();
                targets.add(score.getVariable(name));
            }
            BossMB boss = new BossMB(score);
            boss.setDepth(parameters.getInt("graspDepth"));
            boss.setUseDataOrder(parameters.getBoolean("graspUseDataOrder"));
            boss.setVerbose(parameters.getBoolean("verbose"));
            boss.setFindMb(parameters.getBoolean("mb"));
            boss.setNumStarts(parameters.getInt("numStarts"));
            boss.setKnowledge(this.knowledge);
            boss.bestOrder(score.getVariables(), targets);
            return boss.getGraph();
        }
        BOSS_MB fgesMb = new BOSS_MB(this.score);
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, fgesMb, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        Node target = graph.getNode(this.targets);
        return GraphUtils.markovBlanketDag(target, new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "BOSS-MB using " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("targets");
        params.add("mb");
        params.add("graspDepth");
        params.add("graspUseDataOrder");
        params.add("cacheScores");
        params.add("verbose");
        params.add("numStarts");
        return params;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }
}

