/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.PcAll;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="CPC", command="cpc", algoType=AlgType.forbid_latent_common_causes)
@Bootstrapping
public class CPC
implements Algorithm,
HasKnowledge,
TakesIndependenceWrapper {
    static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private Knowledge knowledge = new Knowledge();

    public CPC() {
    }

    public CPC(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            PcAll.ConflictRule conflictRule;
            if (parameters.getInt("timeLag") > 0) {
                DataSet dataSet = (DataSet)dataModel;
                DataSet timeSeries = TimeSeriesUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                dataModel = timeSeries;
                this.knowledge = timeSeries.getKnowledge();
            }
            PcAll.ColliderDiscovery colliderDiscovery = PcAll.ColliderDiscovery.CONSERVATIVE;
            switch (parameters.getInt("conflictRule")) {
                case 1: {
                    conflictRule = PcAll.ConflictRule.OVERWRITE;
                    break;
                }
                case 2: {
                    conflictRule = PcAll.ConflictRule.BIDIRECTED;
                    break;
                }
                case 3: {
                    conflictRule = PcAll.ConflictRule.PRIORITY;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a choice.");
                }
            }
            PcAll search = new PcAll(this.test.getTest(dataModel, parameters));
            search.setDepth(parameters.getInt("depth"));
            search.setHeuristic(parameters.getInt("fasHeuristic"));
            search.setKnowledge(this.knowledge);
            if (parameters.getBoolean("stableFAS")) {
                search.setFasType(PcAll.FasType.STABLE);
            } else {
                search.setFasType(PcAll.FasType.REGULAR);
            }
            if (parameters.getBoolean("concurrentFAS")) {
                search.setConcurrent(PcAll.Concurrent.YES);
            } else {
                search.setConcurrent(PcAll.Concurrent.NO);
            }
            search.setColliderDiscovery(colliderDiscovery);
            search.setConflictRule(conflictRule);
            search.setUseHeuristic(parameters.getBoolean("useMaxPOrientationHeuristic"));
            search.setMaxPathLength(parameters.getInt("maxPOrientationMaxPathLength"));
            search.setVerbose(parameters.getBoolean("verbose"));
            return search.search();
        }
        CPC pcAll = new CPC(this.test);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, pcAll, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.cpdagForDag(new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "PC using " + this.test.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.test.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("stableFAS");
        parameters.add("concurrentFAS");
        parameters.add("conflictRule");
        parameters.add("depth");
        parameters.add("fasHeuristic");
        parameters.add("useMaxPOrientationHeuristic");
        parameters.add("maxPOrientationMaxPathLength");
        parameters.add("timeLag");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper test) {
        this.test = test;
    }
}

