/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

@Bootstrapping
public class FgesMeasurement
implements Algorithm,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private final ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();

    public FgesMeasurement(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            DataSet dataSet = SimpleDataLoader.getContinuousDataSet(dataModel);
            dataSet = dataSet.copy();
            dataSet = DataUtils.standardizeData(dataSet);
            double variance = parameters.getDouble("measurementVariance");
            if (variance > 0.0) {
                for (int i = 0; i < dataSet.getNumRows(); ++i) {
                    for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                        double d = dataSet.getDouble(i, j);
                        double norm = RandomUtil.getInstance().nextNormal(0.0, FastMath.sqrt(variance));
                        dataSet.setDouble(i, j, d + norm);
                    }
                }
            }
            Fges search = new Fges(this.score.getScore(dataSet, parameters));
            search.setFaithfulnessAssumed(parameters.getBoolean("faithfulnessAssumed"));
            search.setKnowledge(this.knowledge);
            search.setVerbose(parameters.getBoolean("verbose"));
            Object obj = parameters.get("printStream");
            if (obj instanceof PrintStream) {
                search.setOut((PrintStream)obj);
            }
            return search.search();
        }
        FgesMeasurement fgesMeasurement = new FgesMeasurement(this.score);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, fgesMeasurement, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.cpdagForDag(new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "FGES adding measuremnt noise using " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("faithfulnessAssumed");
        parameters.add("measurementVariance");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

