/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.GraspTol;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="GRaSP-Tol", command="grasptol", algoType=AlgType.forbid_latent_common_causes)
@Bootstrapping
@Experimental
public class GRaSPTol
implements Algorithm,
UsesScoreWrapper,
TakesIndependenceWrapper,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private ScoreWrapper score;
    private IndependenceWrapper test;
    private Knowledge knowledge = new Knowledge();

    public GRaSPTol() {
    }

    public GRaSPTol(ScoreWrapper score, IndependenceWrapper test) {
        this.score = score;
        this.test = test;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            if (parameters.getInt("timeLag") > 0) {
                DataSet dataSet = (DataSet)dataModel;
                DataSet timeSeries = TimeSeriesUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                dataModel = timeSeries;
                this.knowledge = timeSeries.getKnowledge();
            }
            Score score = this.score.getScore(dataModel, parameters);
            IndependenceTest test = this.test.getTest(dataModel, parameters);
            test.setVerbose(parameters.getBoolean("verbose"));
            GraspTol grasp = new GraspTol(test, score);
            grasp.setDepth(parameters.getInt("graspDepth"));
            grasp.setUncoveredDepth(parameters.getInt("graspSingularDepth"));
            grasp.setNonSingularDepth(parameters.getInt("graspNonSingularDepth"));
            grasp.setOrdered(parameters.getBoolean("graspOrderedAlg"));
            grasp.setUseScore(parameters.getBoolean("graspUseScore"));
            grasp.setUseRaskuttiUhler(parameters.getBoolean("graspUseRaskuttiUhler"));
            grasp.setUseDataOrder(parameters.getBoolean("graspUseDataOrder"));
            grasp.setToleranceDepth(parameters.getInt("graspToleranceDepth"));
            grasp.setAllowRandomnessInsideAlgorithm(parameters.getBoolean("graspAllowRandomnessIndideAlgorithm"));
            grasp.setVerbose(parameters.getBoolean("verbose"));
            grasp.setCacheScores(parameters.getBoolean("cacheScores"));
            grasp.setNumStarts(parameters.getInt("numStarts"));
            grasp.setKnowledge(this.knowledge);
            grasp.bestOrder(score.getVariables());
            return grasp.getGraph(parameters.getBoolean("outputCpdag"));
        }
        GRaSPTol algorithm = new GRaSPTol(this.score, this.test);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "GRaSPTol (Greedy Relaxed Sparsest Permutation Tolerance) using " + this.test.getDescription() + " or " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("graspDepth");
        params.add("graspSingularDepth");
        params.add("graspNonSingularDepth");
        params.add("graspToleranceDepth");
        params.add("graspOrderedAlg");
        params.add("graspUseRaskuttiUhler");
        params.add("graspUseDataOrder");
        params.add("graspAllowRandomnessIndideAlgorithm");
        params.add("cacheScores");
        params.add("timeLag");
        params.add("verbose");
        params.add("numStarts");
        return params;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper independenceWrapper) {
        this.test = independenceWrapper;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge.copy();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

