/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.PcAll;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@Experimental
@Bootstrapping
public class PcAll
implements Algorithm,
HasKnowledge,
TakesIndependenceWrapper {
    static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private Knowledge knowledge = new Knowledge();

    public PcAll() {
    }

    public PcAll(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            PcAll.ConflictRule conflictRule;
            PcAll.ColliderDiscovery colliderDiscovery;
            switch (parameters.getInt("colliderDiscoveryRule")) {
                case 1: {
                    colliderDiscovery = PcAll.ColliderDiscovery.FAS_SEPSETS;
                    break;
                }
                case 2: {
                    colliderDiscovery = PcAll.ColliderDiscovery.CONSERVATIVE;
                    break;
                }
                case 3: {
                    colliderDiscovery = PcAll.ColliderDiscovery.MAX_P;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a choice.");
                }
            }
            switch (parameters.getInt("conflictRule")) {
                case 1: {
                    conflictRule = PcAll.ConflictRule.OVERWRITE;
                    break;
                }
                case 2: {
                    conflictRule = PcAll.ConflictRule.BIDIRECTED;
                    break;
                }
                case 3: {
                    conflictRule = PcAll.ConflictRule.PRIORITY;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a choice.");
                }
            }
            edu.cmu.tetrad.search.PcAll search = new edu.cmu.tetrad.search.PcAll(this.test.getTest(dataSet, parameters));
            search.setDepth(parameters.getInt("depth"));
            search.setHeuristic(parameters.getInt("fasHeuristic"));
            search.setKnowledge(this.knowledge);
            if (parameters.getBoolean("stableFAS")) {
                search.setFasType(PcAll.FasType.STABLE);
            } else {
                search.setFasType(PcAll.FasType.REGULAR);
            }
            if (parameters.getBoolean("concurrentFAS")) {
                search.setConcurrent(PcAll.Concurrent.YES);
            } else {
                search.setConcurrent(PcAll.Concurrent.NO);
            }
            search.setColliderDiscovery(colliderDiscovery);
            search.setConflictRule(conflictRule);
            search.setUseHeuristic(parameters.getBoolean("useMaxPOrientationHeuristic"));
            search.setMaxPathLength(parameters.getInt("maxPOrientationMaxPathLength"));
            search.setVerbose(parameters.getBoolean("verbose"));
            return search.search();
        }
        PcAll pcAll = new PcAll(this.test);
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, pcAll, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.cpdagForDag(new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "PC using " + this.test.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.test.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("stableFAS");
        parameters.add("concurrentFAS");
        parameters.add("colliderDiscoveryRule");
        parameters.add("conflictRule");
        parameters.add("depth");
        parameters.add("fasHeuristic");
        parameters.add("useMaxPOrientationHeuristic");
        parameters.add("maxPOrientationMaxPathLength");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper test) {
        this.test = test;
    }
}

