/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SimpleDemoGA;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

public class SIMPLE_DEMO_GA
implements Algorithm,
UsesScoreWrapper,
TakesIndependenceWrapper,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private ScoreWrapper score;
    private IndependenceWrapper test;
    private Knowledge knowledge = new Knowledge();

    public SIMPLE_DEMO_GA() {
    }

    public SIMPLE_DEMO_GA(ScoreWrapper score, IndependenceWrapper test) {
        this.score = score;
        this.test = test;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            if (parameters.getInt("timeLag") > 0) {
                DataSet dataSet = (DataSet)dataModel;
                DataSet timeSeries = TimeSeriesUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                dataModel = timeSeries;
                this.knowledge = timeSeries.getKnowledge();
            }
            Score score = this.score.getScore(dataModel, parameters);
            IndependenceTest test = this.test.getTest(dataModel, parameters);
            test.setVerbose(parameters.getBoolean("verbose"));
            SimpleDemoGA boss = new SimpleDemoGA(score, 10);
            return boss.search();
        }
        SIMPLE_DEMO_GA algorithm = new SIMPLE_DEMO_GA(this.score, this.test);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "SIMPLE_DEMO_GA using " + this.test.getDescription() + " or " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.score.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("graspDepth");
        params.add("graspUseScore");
        params.add("graspUseRaskuttiUhler");
        params.add("graspUseDataOrder");
        params.add("cacheScores");
        params.add("verbose");
        params.add("numStarts");
        return params;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper independenceWrapper) {
        this.test = independenceWrapper;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge.copy();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

