/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.pag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.GraspFci;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="GRASP-FCI", command="grasp-fci", algoType=AlgType.allow_latent_common_causes)
@Bootstrapping
public class GRASP_FCI
implements Algorithm,
UsesScoreWrapper,
TakesIndependenceWrapper,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();

    public GRASP_FCI() {
    }

    public GRASP_FCI(IndependenceWrapper test, ScoreWrapper score) {
        this.test = test;
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            if (parameters.getInt("timeLag") > 0) {
                DataSet dataSet = (DataSet)dataModel;
                DataSet timeSeries = TimeSeriesUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                dataModel = timeSeries;
                this.knowledge = timeSeries.getKnowledge();
            }
            IndependenceTest test = this.test.getTest(dataModel, parameters);
            Score score = this.score.getScore(dataModel, parameters);
            test.setVerbose(parameters.getBoolean("verbose"));
            GraspFci search = new GraspFci(test, score);
            search.setDepth(parameters.getInt("graspDepth"));
            search.setSingularDepth(parameters.getInt("graspSingularDepth"));
            search.setNonSingularDepth(parameters.getInt("graspNonSingularDepth"));
            search.setOrdered(parameters.getBoolean("graspOrderedAlg"));
            search.setUseScore(parameters.getBoolean("graspUseScore"));
            search.setUseRaskuttiUhler(parameters.getBoolean("graspUseRaskuttiUhler"));
            search.setUseDataOrder(parameters.getBoolean("graspUseDataOrder"));
            search.setCacheScores(parameters.getBoolean("cacheScores"));
            search.setNumStarts(parameters.getInt("numStarts"));
            search.setDepth(parameters.getInt("depth"));
            search.setMaxPathLength(parameters.getInt("maxPathLength"));
            search.setCompleteRuleSetUsed(parameters.getBoolean("completeRuleSetUsed"));
            search.setDoDiscriminatingPathRule(parameters.getBoolean("doDiscriminatingPathRule"));
            search.setPossibleDsepSearchDone(parameters.getBoolean("possibleDsepDone"));
            search.setVerbose(parameters.getBoolean("verbose"));
            search.setKnowledge(this.knowledge);
            Object obj = parameters.get("printStream");
            if (obj instanceof PrintStream) {
                search.setOut((PrintStream)obj);
            }
            return search.search();
        }
        GRASP_FCI algorithm = new GRASP_FCI(this.test, this.score);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(data.getKnowledge());
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.dagToPag(graph);
    }

    @Override
    public String getDescription() {
        return "GRASP-FCI (GRaSP FCI) using " + this.test.getDescription() + " and " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.test.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("graspDepth");
        params.add("graspSingularDepth");
        params.add("graspNonSingularDepth");
        params.add("graspOrderedAlg");
        params.add("graspUseRaskuttiUhler");
        params.add("graspUseDataOrder");
        params.add("cacheScores");
        params.add("numStarts");
        params.add("depth");
        params.add("maxPathLength");
        params.add("completeRuleSetUsed");
        params.add("doDiscriminatingPathRule");
        params.add("possibleDsepDone");
        params.add("timeLag");
        params.add("verbose");
        return params;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }
}

