/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.pag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.LvSwap;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="LV-Swap-2a", command="lv-swap-2a", algoType=AlgType.allow_latent_common_causes)
@Bootstrapping
@Experimental
public class LVSWAP_2a
implements Algorithm,
UsesScoreWrapper,
TakesIndependenceWrapper,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();

    public LVSWAP_2a() {
    }

    public LVSWAP_2a(IndependenceWrapper test, ScoreWrapper score) {
        this.test = test;
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataModel, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            if (parameters.getInt("timeLag") > 0) {
                DataSet dataSet = (DataSet)dataModel;
                DataSet timeSeries = TimeSeriesUtils.createLagData(dataSet, parameters.getInt("timeLag"));
                if (dataSet.getName() != null) {
                    timeSeries.setName(dataSet.getName());
                }
                dataModel = timeSeries;
                this.knowledge = timeSeries.getKnowledge();
            }
            LvSwap search = new LvSwap(this.test.getTest(dataModel, parameters), this.score.getScore(dataModel, parameters));
            if (parameters.getInt("bossAlg") == 1) {
                search.setBossAlgType(Boss.AlgType.BOSS1);
            } else if (parameters.getInt("bossAlg") == 2) {
                search.setBossAlgType(Boss.AlgType.BOSS2);
            } else if (parameters.getInt("bossAlg") == 3) {
                search.setBossAlgType(Boss.AlgType.BOSS3);
            } else {
                throw new IllegalArgumentException("Unrecognized boss algorithm type.");
            }
            search.setMaxPathLength(parameters.getInt("maxPathLength"));
            search.setCompleteRuleSetUsed(parameters.getBoolean("completeRuleSetUsed"));
            search.setAlgType(LvSwap.AlgType.LVSwap2a);
            search.setDepth(-1);
            search.setUseScore(parameters.getBoolean("graspUseScore"));
            search.setUseRaskuttiUhler(parameters.getBoolean("graspUseRaskuttiUhler"));
            search.setDoDefiniteDiscriminatingPathTailRule(parameters.getBoolean("doDiscriminatingPathTailRule"));
            search.setUseDataOrder(parameters.getBoolean("graspUseDataOrder"));
            search.setVerbose(parameters.getBoolean("verbose"));
            search.setKnowledge(this.knowledge);
            search.setNumStarts(parameters.getInt("numStarts"));
            Object obj = parameters.get("printStream");
            if (obj instanceof PrintStream) {
                search.setOut((PrintStream)obj);
            }
            Graph graph = search.search();
            LayoutUtil.circleLayout(graph, 200, 200, 150);
            return graph;
        }
        LVSWAP_2a algorithm = new LVSWAP_2a(this.test, this.score);
        DataSet data = (DataSet)dataModel;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(data.getKnowledge());
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.dagToPag(graph);
    }

    @Override
    public String getDescription() {
        return "LV-Swap-2a (BOSS + swap rules) using " + this.test.getDescription() + " and " + this.score.getDescription();
    }

    @Override
    public DataType getDataType() {
        return this.test.getDataType();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("bossAlg");
        params.add("completeRuleSetUsed");
        params.add("doDiscriminatingPathTailRule");
        params.add("graspUseScore");
        params.add("graspUseRaskuttiUhler");
        params.add("graspUseDataOrder");
        params.add("timeLag");
        params.add("verbose");
        params.add("numStarts");
        return params;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper test) {
        this.test = test;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }
}

