/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.oracle.pattern;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Cstar;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="CStaR", command="cstar", algoType=AlgType.forbid_latent_common_causes)
public class CStaR
implements Algorithm,
TakesIndependenceWrapper {
    static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private LinkedList<Cstar.Record> records;

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        System.out.println("# Available Processors = " + Runtime.getRuntime().availableProcessors());
        System.out.println("Parallelized = " + parameters.getBoolean("parallelized"));
        Cstar cStaR = new Cstar();
        cStaR.setParallelized(parameters.getBoolean("parallelized"));
        cStaR.setNumSubsamples(parameters.getInt("numSubsamples"));
        cStaR.setqFrom(parameters.getInt("cstarQ"));
        cStaR.setqTo(parameters.getInt("cstarQ"));
        cStaR.setSelectionAlpha(parameters.getDouble("selectionMinEffect"));
        cStaR.setqIncrement(1);
        cStaR.setPatternAlgorithm(Cstar.PatternAlgorithm.PC_STABLE);
        cStaR.setSampleStyle(Cstar.SampleStyle.SPLIT);
        cStaR.setVerbose(parameters.getBoolean("verbose"));
        ArrayList<Node> possibleEffects = new ArrayList<Node>();
        String targetNames = parameters.getString("targets");
        if (targetNames.trim().equalsIgnoreCase("")) {
            throw new IllegalStateException("Please specify target name(s).");
        }
        if (targetNames.trim().equalsIgnoreCase("all")) {
            for (String string : dataSet.getVariableNames()) {
                possibleEffects.add(dataSet.getVariable(string));
            }
        } else {
            String[] names;
            for (String name : names = targetNames.split(",")) {
                possibleEffects.add(dataSet.getVariable(name.trim()));
            }
        }
        ArrayList<Node> possibleCauses = new ArrayList<Node>(dataSet.getVariables());
        if (!(dataSet instanceof DataSet)) {
            throw new IllegalArgumentException("Expecting tabular data for CStaR.");
        }
        LinkedList<LinkedList<Cstar.Record>> linkedList = cStaR.getRecords((DataSet)dataSet, possibleCauses, possibleEffects, this.test.getTest(dataSet, parameters));
        if (linkedList.isEmpty()) {
            throw new IllegalStateException("There were no records.");
        }
        this.records = linkedList.getLast();
        TetradLogger.getInstance().forceLogMessage("CStaR Table");
        TetradLogger.getInstance().forceLogMessage(cStaR.makeTable(Cstar.cStar(linkedList), true));
        TetradLogger.getInstance().forceLogMessage("\nStability Selection Table");
        TetradLogger.getInstance().forceLogMessage(cStaR.makeTable(this.getRecords(), true));
        return cStaR.makeGraph(this.getRecords());
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph();
    }

    @Override
    public String getDescription() {
        return "CStaR";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>(this.test.getParameters());
        parameters.add("selectionMinEffect");
        parameters.add("penaltyDiscount");
        parameters.add("numSubsamples");
        parameters.add("targets");
        parameters.add("cstarQ");
        parameters.add("parallelized");
        parameters.add("verbose");
        return parameters;
    }

    public LinkedList<Cstar.Record> getRecords() {
        return this.records;
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper independenceWrapper) {
        this.test = independenceWrapper;
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }
}

