/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.pairwise;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.utils.TakesExternalGraph;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Lofs2;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="RSkew", command="r-skew", algoType=AlgType.orient_pairwise, dataType={DataType.Continuous})
@Bootstrapping
public class RSkew
implements Algorithm,
TakesExternalGraph {
    static final long serialVersionUID = 23L;
    private Algorithm algorithm;
    private Graph externalGraph;

    public RSkew() {
    }

    public RSkew(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            Graph graph = this.algorithm.search(dataSet, parameters);
            if (graph == null) {
                throw new IllegalArgumentException("This RSkew algorithm needs both data and a graph source as inputs; it \nwill orient the edges in the input graph using the data");
            }
            this.externalGraph = graph;
            ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
            dataSets.add(SimpleDataLoader.getContinuousDataSet(dataSet));
            Lofs2 lofs = new Lofs2(this.externalGraph, dataSets);
            lofs.setRule(Lofs2.Rule.RSkew);
            return lofs.orient();
        }
        RSkew rSkew = new RSkew(this.algorithm);
        if (this.externalGraph != null) {
            rSkew.setExternalGraph(this.algorithm);
        }
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, rSkew, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        return "RSkew" + (this.algorithm != null ? " with initial graph from " + this.algorithm.getDescription() : "");
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.algorithm != null && !this.algorithm.getParameters().isEmpty()) {
            parameters.addAll(this.algorithm.getParameters());
        }
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public void setExternalGraph(Algorithm algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("This RSkew algorithm needs both data and a graph source as inputs; it \nwill orient the edges in the input graph using the data.");
        }
        this.algorithm = algorithm;
    }
}

