/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.examples;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.CPC;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.PC;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.PCMAX;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.F1Adj;
import edu.cmu.tetrad.algcomparison.statistic.F1Arrow;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrAdj;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrArrow;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.SHD;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class ExampleCompareFromFiles {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("alpha", (Object)1.0E-4);
        parameters.set("numRuns", (Object)10);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("avgDegree"));
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new MathewsCorrAdj());
        statistics.add(new MathewsCorrArrow());
        statistics.add(new F1Adj());
        statistics.add(new F1Arrow());
        statistics.add(new SHD());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 0.5);
        statistics.setWeight("AHP", 1.0);
        statistics.setWeight("AHR", 0.5);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new PC(new FisherZ()));
        algorithms.add(new CPC(new FisherZ()));
        algorithms.add(new PCMAX(new FisherZ()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(false);
        comparison.setShowSimulationIndices(false);
        comparison.setSortByUtility(true);
        comparison.setShowUtilities(true);
        comparison.compareFromFiles("comparison", algorithms, statistics, parameters);
    }
}

