/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.examples;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.score.ConditionalGaussianBicScore;
import edu.cmu.tetrad.algcomparison.simulation.BayesNetSimulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class ExampleCompareSimulation2 {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numRuns", (Object)1);
        parameters.set("numMeasures", (Object)20);
        parameters.set("avgDegree", (Object)4);
        parameters.set("randomizeColumns", (Object)true);
        Statistics statistics = new Statistics();
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 0.5);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new Fges(new ConditionalGaussianBicScore()));
        Simulations simulations = new Simulations();
        simulations.add(new BayesNetSimulation(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(true);
        comparison.setShowUtilities(true);
        comparison.setSaveGraphs(true);
        comparison.compareFromSimulations("comparetest", simulations, algorithms, statistics, parameters);
    }
}

