/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.examples;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.BOSS;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class TestBoss {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numRuns", (Object)1);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("numMeasures", (Object)500);
        parameters.set("avgDegree", (Object)10);
        parameters.set("sampleSize", (Object)1000);
        parameters.set("coefLow", (Object)0);
        parameters.set("coefHigh", (Object)1);
        parameters.set("bossAlg", (Object)1);
        parameters.set("penaltyDiscount", (Object)2);
        parameters.set("semBicStructurePrior", (Object)0);
        parameters.set("alpha", (Object)0.01);
        parameters.set("verbose", (Object)true);
        Statistics statistics = new Statistics();
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ElapsedCpuTime());
        Algorithms algorithms = new Algorithms();
        algorithms.add(new BOSS(new FisherZ(), new SemBicScore()));
        Simulations simulations = new Simulations();
        simulations.add(new SemSimulation(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.setParallelized(false);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.CPDAG_of_the_true_DAG);
        comparison.compareFromSimulations("comparison", simulations, algorithms, statistics, parameters);
    }
}

