/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.graph;

import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

public class ErdosRenyi
implements RandomGraph {
    static final long serialVersionUID = 23L;

    @Override
    public Graph createGraph(Parameters parameters) {
        double p = parameters.getDouble("probabilityOfEdge");
        int m = parameters.getInt("numMeasures");
        int l = parameters.getInt("numLatents");
        int t = (m + l) * (m + l - 1) / 2;
        int max = Integer.MAX_VALUE;
        int e = (int)(p * (double)t);
        return edu.cmu.tetrad.graph.RandomGraph.randomGraphRandomForwardEdges(m + l, l, e, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, false);
    }

    @Override
    public String getDescription() {
        return "Graph constructed the Erdos-Renyi method (p fixed, # edges not)";
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("numMeasures");
        parameters.add("numLatents");
        parameters.add("probabilityOfEdge");
        return parameters;
    }
}

