/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.General;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.search.ConditionalCorrelationIndependenceLingam;
import edu.cmu.tetrad.search.IndTestConditionalCorrelationLingam;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="CCI-Lingam-Test (Conditional Correlation Independence Lingam Test)", command="cci-lingam-test", dataType={DataType.Continuous})
@General
public class CciLingamTest
implements IndependenceWrapper {
    static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        IndTestConditionalCorrelationLingam cci = new IndTestConditionalCorrelationLingam(SimpleDataLoader.getContinuousDataSet(dataSet), parameters.getDouble("alpha"));
        if (parameters.getInt("basisType") == 1) {
            cci.setBasis(ConditionalCorrelationIndependenceLingam.Basis.Polynomial);
        } else if (parameters.getInt("basisType") == 2) {
            cci.setBasis(ConditionalCorrelationIndependenceLingam.Basis.Cosine);
        } else {
            throw new IllegalStateException("Basis not configured.");
        }
        cci.setNumFunctions(parameters.getInt("numBasisFunctions"));
        return cci;
    }

    @Override
    public String getDescription() {
        return "CCI Test";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("alpha");
        params.add("numBasisFunctions");
        params.add("basisType");
        return params;
    }
}

