/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.General;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.search.ConditionalCorrelationIndependence;
import edu.cmu.tetrad.search.IndTestConditionalCorrelation;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="CCI-Test (Conditional Correlation Independence Test)", command="cci-test", dataType={DataType.Continuous})
@General
public class CciTest
implements IndependenceWrapper {
    static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        IndTestConditionalCorrelation cci = new IndTestConditionalCorrelation(SimpleDataLoader.getContinuousDataSet(dataSet), parameters.getDouble("alpha"));
        if (parameters.getInt("kernelType") == 1) {
            cci.setKernel(ConditionalCorrelationIndependence.Kernel.Gaussian);
        } else if (parameters.getInt("kernelType") == 2) {
            cci.setKernel(ConditionalCorrelationIndependence.Kernel.Epinechnikov);
        } else {
            throw new IllegalStateException("Kernel not configured.");
        }
        if (parameters.getInt("basisType") == 1) {
            cci.setBasis(ConditionalCorrelationIndependence.Basis.Polynomial);
        } else if (parameters.getInt("basisType") == 2) {
            cci.setBasis(ConditionalCorrelationIndependence.Basis.Cosine);
        } else {
            throw new IllegalStateException("Basis not configured.");
        }
        cci.setNumFunctions(parameters.getInt("numBasisFunctions"));
        cci.setKernelMultiplier(parameters.getDouble("kernelMultiplier"));
        cci.setKernelRegressionSampleSize(parameters.getInt("kernelRegressionSampleSize"));
        return cci;
    }

    @Override
    public String getDescription() {
        return "CCI Test";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("alpha");
        params.add("numBasisFunctions");
        params.add("kernelType");
        params.add("kernelMultiplier");
        params.add("basisType");
        params.add("kernelRegressionSampleSize");
        return params;
    }
}

