/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.independence;

import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.search.IndTestScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.KimEtAlScores;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@TestOfIndependence(name="Kim et al. BIC Tests", command="kim-bic-tests", dataType={DataType.Continuous, DataType.Covariance})
@LinearGaussian
public class KimEtAlScoreTests
implements IndependenceWrapper {
    static final long serialVersionUID = 23L;

    @Override
    public IndependenceTest getTest(DataModel dataSet, Parameters parameters) {
        KimEtAlScores.RuleType ruleType;
        KimEtAlScores score;
        if (dataSet instanceof DataSet) {
            score = new KimEtAlScores((DataSet)dataSet);
        } else if (dataSet instanceof ICovarianceMatrix) {
            score = new KimEtAlScores((ICovarianceMatrix)dataSet);
        } else {
            throw new IllegalArgumentException("Expecting either a dataset or a covariance matrix.");
        }
        int anInt = parameters.getInt("semGicRule");
        switch (anInt) {
            case 1: {
                ruleType = KimEtAlScores.RuleType.BIC;
                break;
            }
            case 2: {
                ruleType = KimEtAlScores.RuleType.GIC2;
                break;
            }
            case 3: {
                ruleType = KimEtAlScores.RuleType.RIC;
                break;
            }
            case 4: {
                ruleType = KimEtAlScores.RuleType.RICc;
                break;
            }
            case 5: {
                ruleType = KimEtAlScores.RuleType.GIC5;
                break;
            }
            case 6: {
                ruleType = KimEtAlScores.RuleType.GIC6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized rule type: " + anInt);
            }
        }
        score.setRuleType(ruleType);
        score.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        return new IndTestScore(score, dataSet);
    }

    @Override
    public String getDescription() {
        return "Kim et al. BIC Tests";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("semGicRule");
        params.add("penaltyDiscountZs");
        return params;
    }
}

