/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Mixed;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SemBicScoreDGWrapper;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Score(name="DG-BIC (Degenerate Gaussian BIC Score)", command="dg-bic-score", dataType={DataType.Mixed})
@Mixed
public class DegenerateGaussianBicScore
implements ScoreWrapper {
    static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public Score getScore(DataModel dataSet, Parameters parameters) {
        this.dataSet = dataSet;
        SemBicScoreDGWrapper degenerateGaussianScore = new SemBicScoreDGWrapper(SimpleDataLoader.getMixedDataSet(dataSet));
        degenerateGaussianScore.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        degenerateGaussianScore.setStructurePrior(parameters.getDouble("structurePrior"));
        return degenerateGaussianScore;
    }

    @Override
    public String getDescription() {
        return "Degenerate Gaussian BIC Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("penaltyDiscount");
        parameters.add("structurePrior");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

