/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.KimEtAlScores;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Score(name="Kim et al. Scores", command="kim-scores", dataType={DataType.Continuous, DataType.Covariance})
@LinearGaussian
public class KimEtAlScores
implements ScoreWrapper {
    static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public Score getScore(DataModel dataSet, Parameters parameters) {
        KimEtAlScores.RuleType ruleType;
        edu.cmu.tetrad.search.KimEtAlScores score;
        this.dataSet = dataSet;
        if (dataSet instanceof DataSet) {
            score = new edu.cmu.tetrad.search.KimEtAlScores((DataSet)this.dataSet);
        } else if (dataSet instanceof ICovarianceMatrix) {
            score = new edu.cmu.tetrad.search.KimEtAlScores((ICovarianceMatrix)this.dataSet);
        } else {
            throw new IllegalArgumentException("Expecting either a dataset or a covariance matrix.");
        }
        int anInt = parameters.getInt("semGicRule");
        switch (anInt) {
            case 1: {
                ruleType = KimEtAlScores.RuleType.BIC;
                break;
            }
            case 2: {
                ruleType = KimEtAlScores.RuleType.GIC2;
                break;
            }
            case 3: {
                ruleType = KimEtAlScores.RuleType.RIC;
                break;
            }
            case 4: {
                ruleType = KimEtAlScores.RuleType.RICc;
                break;
            }
            case 5: {
                ruleType = KimEtAlScores.RuleType.GIC5;
                break;
            }
            case 6: {
                ruleType = KimEtAlScores.RuleType.GIC6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized rule type: " + anInt);
            }
        }
        score.setRuleType(ruleType);
        score.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
        return score;
    }

    @Override
    public String getDescription() {
        return "Kim et al. Scores";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("semGicRule");
        parameters.add("penaltyDiscountZs");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

