/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.MNLRScore;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@Experimental
@edu.cmu.tetrad.annotation.Score(name="Multinomial Logistic Regression BIC Score", command="mnlr-bic-score", dataType={DataType.Mixed})
public class MNLRBicScore
implements ScoreWrapper {
    static final long serialVersionUID = 23L;

    @Override
    public Score getScore(DataModel dataSet, Parameters parameters) {
        return new MNLRScore(SimpleDataLoader.getMixedDataSet(dataSet), 1.0, parameters.getInt("fDegree", 1));
    }

    @Override
    public String getDescription() {
        return "Multinomial Logistic Regression BIC Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("fDegree");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return null;
    }
}

