/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.score;

import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.LinearGaussian;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Score(name="Poisson Prior Score", command="poisson-prior-score", dataType={DataType.Continuous, DataType.Covariance})
@LinearGaussian
public class PoissonPriorScore
implements ScoreWrapper {
    static final long serialVersionUID = 23L;
    private DataModel dataSet;

    @Override
    public Score getScore(DataModel dataSet, Parameters parameters) {
        edu.cmu.tetrad.search.PoissonPriorScore score;
        this.dataSet = dataSet;
        if (dataSet instanceof DataSet) {
            score = new edu.cmu.tetrad.search.PoissonPriorScore((DataSet)this.dataSet, parameters.getBoolean("precomputeCovariances"));
        } else if (dataSet instanceof ICovarianceMatrix) {
            score = new edu.cmu.tetrad.search.PoissonPriorScore((ICovarianceMatrix)this.dataSet);
        } else {
            throw new IllegalArgumentException("Expecting either a dataset or a covariance matrix.");
        }
        score.setLambda(parameters.getDouble("poissonLambda"));
        return score;
    }

    @Override
    public String getDescription() {
        return "Poisson Prior Score";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("precomputeCovariances");
        parameters.add("poissonLambda");
        return parameters;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }
}

