/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.simulation;

import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.annotation.Experimental;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.gene.tetrad.gene.graph.LagGraphParams;
import edu.cmu.tetrad.gene.tetrad.gene.graph.RandomActiveLagGraph;
import edu.cmu.tetrad.gene.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.gene.tetradapp.model.BooleanGlassGeneIm;
import edu.cmu.tetrad.gene.tetradapp.model.BooleanGlassGenePm;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@Experimental
public class BooleanGlassSimulation
implements Simulation {
    static final long serialVersionUID = 23L;
    private final RandomGraph randomGraph;
    private List<DataSet> dataSets = new ArrayList<DataSet>();
    private Graph graph = new EdgeListGraph();

    public BooleanGlassSimulation(RandomGraph graph) {
        this.randomGraph = graph;
    }

    @Override
    public void createData(Parameters parameters, boolean newModel) {
        if (parameters.getLong("seed") != -1L) {
            RandomUtil.getInstance().setSeed(parameters.getLong("seed"));
        }
        this.graph = this.randomGraph.createGraph(parameters);
        LagGraphParams params = new LagGraphParams(parameters);
        params.setIndegree(2);
        params.setMlag(1);
        RandomActiveLagGraph _graph = new RandomActiveLagGraph(params);
        BooleanGlassGenePm pm = new BooleanGlassGenePm(_graph);
        BooleanGlassGeneIm im = new BooleanGlassGeneIm(pm, parameters);
        DataModelList data = im.simulateData();
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (DataModel model : data) {
            dataSets.add((DataSet)model);
        }
        this.dataSets = dataSets;
        ArrayList<String> factors = new ArrayList<String>(_graph.getFactors());
        HashMap<String, ContinuousVariable> nodes = new HashMap<String, ContinuousVariable>();
        for (String factor : factors) {
            nodes.put(factor, new ContinuousVariable(factor));
        }
        TimeLagGraph graph = new TimeLagGraph();
        graph.setMaxLag(_graph.getMaxLag());
        for (String factor : factors) {
            graph.addNode((Node)nodes.get(factor));
        }
        for (String factor : factors) {
            for (Object e : _graph.getParents(factor)) {
                LaggedFactor laggedFactor = (LaggedFactor)e;
                String _factor = laggedFactor.getFactor();
                int lag = laggedFactor.getLag();
                Node node1 = graph.getNode(_factor + ":" + lag);
                Node node2 = graph.getNode(factor);
                graph.addDirectedEdge(node1, node2);
            }
        }
        BooleanGlassSimulation.topToBottomLayout(graph);
        this.graph = graph;
    }

    public static void topToBottomLayout(TimeLagGraph graph) {
        int xStart = 65;
        int yStart = 50;
        int xSpace = 100;
        int ySpace = 100;
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int x = -35;
        for (Node node : lag0Nodes) {
            x += 100;
            int y = -50;
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                y += 100;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find " + null);
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
            }
        }
    }

    @Override
    public Graph getTrueGraph(int index) {
        return this.graph;
    }

    @Override
    public DataModel getDataModel(int index) {
        return this.dataSets.get(index);
    }

    @Override
    public String getDescription() {
        return "Boolean Glass Simulation " + this.randomGraph.getDescription();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("lagGraphVarsPerInd");
        parameters.add("lagGraphMlag");
        parameters.add("lagGraphIndegree");
        parameters.add("numDishes");
        parameters.add("includeDishAndChipColumns");
        parameters.add("numChipsPerDish");
        parameters.add("numCellsPerDish");
        parameters.add("stepsGenerated");
        parameters.add("firstStepStored");
        parameters.add("interval");
        parameters.add("rawDataSaved");
        parameters.add("measuredDataSaved");
        parameters.add("initSync");
        parameters.add("antilogCalculated");
        parameters.add("dishDishVariability");
        parameters.add("sampleSampleVariability");
        parameters.add("chipChipVariability");
        parameters.add("pixelDigitalization");
        parameters.add("seed");
        return parameters;
    }

    @Override
    public int getNumDataModels() {
        return this.dataSets.size();
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }
}

