/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.simulation;

import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.algcomparison.graph.SingleGraph;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class SemSimulation
implements Simulation {
    static final long serialVersionUID = 23L;
    private final RandomGraph randomGraph;
    private SemPm pm;
    private SemIm im;
    private List<DataSet> dataSets = new ArrayList<DataSet>();
    private List<Graph> graphs = new ArrayList<Graph>();
    private List<SemIm> ims = new ArrayList<SemIm>();

    public SemSimulation(RandomGraph graph) {
        this.randomGraph = graph;
    }

    public SemSimulation(SemPm pm) {
        SemGraph graph = pm.getGraph();
        graph.setShowErrorTerms(false);
        this.randomGraph = new SingleGraph(graph);
        this.pm = pm;
    }

    public SemSimulation(SemIm im) {
        SemGraph graph = im.getSemPm().getGraph();
        graph.setShowErrorTerms(false);
        EdgeListGraph graph2 = new EdgeListGraph(graph);
        this.randomGraph = new SingleGraph(graph2);
        this.im = new SemIm(im);
        this.pm = new SemPm(im.getSemPm());
        this.ims = new ArrayList<SemIm>();
        this.ims.add(im);
    }

    @Override
    public void createData(Parameters parameters, boolean newModel) {
        if (parameters.getLong("seed") != -1L) {
            RandomUtil.getInstance().setSeed(parameters.getLong("seed"));
        }
        Graph graph = this.randomGraph.createGraph(parameters);
        this.dataSets = new ArrayList<DataSet>();
        this.graphs = new ArrayList<Graph>();
        this.ims = new ArrayList<SemIm>();
        for (int i = 0; i < parameters.getInt("numRuns"); ++i) {
            double variance;
            System.out.println("Simulating dataset #" + (i + 1));
            if (parameters.getBoolean("differentGraphs") && i > 0) {
                graph = this.randomGraph.createGraph(parameters);
            }
            this.graphs.add(graph);
            DataSet dataSet = this.simulate(graph, parameters);
            if (parameters.getBoolean("standardize")) {
                dataSet = DataUtils.standardizeData(dataSet);
            }
            if ((variance = parameters.getDouble("measurementVariance")) > 0.0) {
                for (int k = 0; k < dataSet.getNumRows(); ++k) {
                    for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                        double d = dataSet.getDouble(k, j);
                        double norm = RandomUtil.getInstance().nextNormal(0.0, FastMath.sqrt(variance));
                        dataSet.setDouble(k, j, d + norm);
                    }
                }
            }
            if (parameters.getBoolean("randomizeColumns")) {
                dataSet = DataUtils.shuffleColumns(dataSet);
            }
            dataSet.setName("" + (i + 1));
            this.dataSets.add(dataSet);
        }
    }

    @Override
    public DataModel getDataModel(int index) {
        return this.dataSets.get(index);
    }

    @Override
    public Graph getTrueGraph(int index) {
        return this.graphs.get(index);
    }

    @Override
    public String getDescription() {
        return "Linear, Gaussian SEM simulation using " + this.randomGraph.getDescription();
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (!(this.randomGraph instanceof SingleGraph)) {
            parameters.addAll(this.randomGraph.getParameters());
        }
        parameters.addAll(SemIm.getParameterNames());
        parameters.add("measurementVariance");
        parameters.add("numRuns");
        parameters.add("differentGraphs");
        parameters.add("randomizeColumns");
        parameters.add("sampleSize");
        parameters.add("saveLatentVars");
        parameters.add("standardize");
        parameters.add("simulationErrorType");
        parameters.add("simulationParam1");
        parameters.add("simulationParam2");
        parameters.add("seed");
        return parameters;
    }

    @Override
    public int getNumDataModels() {
        return this.dataSets.size();
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    private DataSet simulate(Graph graph, Parameters parameters) {
        SemIm im;
        boolean saveLatentVars = parameters.getBoolean("saveLatentVars");
        SemPm pm = this.pm;
        if (pm == null) {
            pm = new SemPm(graph);
        }
        this.im = im = new SemIm(pm, parameters);
        this.im.setParams(parameters);
        this.ims.add(im);
        return this.im.simulateData(parameters.getInt("sampleSize"), saveLatentVars);
    }

    public List<SemIm> getSemIms() {
        return this.ims;
    }
}

