/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.simulation;

import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.algcomparison.simulation.BayesNetSimulation;
import edu.cmu.tetrad.algcomparison.simulation.BooleanGlassSimulation;
import edu.cmu.tetrad.algcomparison.simulation.ConditionalGaussianSimulation;
import edu.cmu.tetrad.algcomparison.simulation.GeneralSemSimulationSpecial1;
import edu.cmu.tetrad.algcomparison.simulation.LeeHastieSimulation;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.algcomparison.simulation.TimeSeriesSemSimulation;

public final class SimulationUtils {
    private SimulationUtils() {
    }

    public static Simulation create(String simulationType, RandomGraph randomGraph) {
        switch (simulationType) {
            case "Bayes Net": {
                return new BayesNetSimulation(randomGraph);
            }
            case "Structural Equation Model": {
                return new SemSimulation(randomGraph);
            }
            case "General Structural Equation Model": {
                return new GeneralSemSimulationSpecial1(randomGraph);
            }
            case "Lee & Hastie": {
                return new LeeHastieSimulation(randomGraph);
            }
            case "Conditional Gaussian": {
                return new ConditionalGaussianSimulation(randomGraph);
            }
            case "Time Series": {
                return new TimeSeriesSemSimulation(randomGraph);
            }
            case "Boolean Glass Simulation": {
                return new BooleanGlassSimulation(randomGraph);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown simulation type %s.", simulationType));
    }
}

