/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.simulation;

import edu.cmu.tetrad.algcomparison.graph.RandomGraph;
import edu.cmu.tetrad.algcomparison.graph.SingleGraph;
import edu.cmu.tetrad.algcomparison.simulation.Simulation;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TimeSeriesSemSimulation
implements Simulation,
HasKnowledge {
    static final long serialVersionUID = 23L;
    private final RandomGraph randomGraph;
    private List<Graph> graphs = new ArrayList<Graph>();
    private List<DataSet> dataSets = new ArrayList<DataSet>();
    private Knowledge knowledge;

    public TimeSeriesSemSimulation(RandomGraph randomGraph) {
        if (randomGraph == null) {
            throw new NullPointerException();
        }
        this.randomGraph = randomGraph;
    }

    @Override
    public void createData(Parameters parameters, boolean newModel) {
        this.dataSets = new ArrayList<DataSet>();
        this.graphs = new ArrayList<Graph>();
        Graph graph = this.randomGraph.createGraph(parameters);
        graph = TimeSeriesUtils.graphToLagGraph(graph, parameters.getInt("numLags"));
        TimeSeriesSemSimulation.topToBottomLayout((TimeLagGraph)graph);
        this.knowledge = TimeSeriesUtils.getKnowledge(graph);
        for (int i = 0; i < parameters.getInt("numRuns"); ++i) {
            if (parameters.getBoolean("differentGraphs") && i > 0) {
                graph = this.randomGraph.createGraph(parameters);
                graph = TimeSeriesUtils.graphToLagGraph(graph, 2);
                TimeSeriesSemSimulation.topToBottomLayout((TimeLagGraph)graph);
            }
            this.graphs.add(graph);
            SemPm pm = new SemPm(graph);
            SemIm im = new SemIm(pm, parameters);
            int sampleSize = parameters.getInt("sampleSize");
            boolean saveLatentVars = parameters.getBoolean("saveLatentVars");
            DataSet dataSet = im.simulateData(sampleSize, saveLatentVars);
            int numLags = ((TimeLagGraph)graph).getMaxLag();
            dataSet = TimeSeriesUtils.createLagData(dataSet, numLags);
            dataSet.setName("" + (i + 1));
            dataSet.setKnowledge(this.knowledge.copy());
            this.dataSets.add(dataSet);
        }
    }

    @Override
    public DataModel getDataModel(int index) {
        return this.dataSets.get(index);
    }

    @Override
    public Graph getTrueGraph(int index) {
        return this.graphs.get(index);
    }

    @Override
    public String getDescription() {
        return "Linear, Gaussian Dynamic SEM (1-lag SVAR) simulation";
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("numLags");
        if (!(this.randomGraph instanceof SingleGraph)) {
            parameters.addAll(this.randomGraph.getParameters());
        }
        parameters.addAll(SemIm.getParameterNames());
        parameters.add("standardize");
        parameters.add("measurementVariance");
        parameters.add("numRuns");
        parameters.add("differentGraphs");
        parameters.add("sampleSize");
        parameters.add("saveLatentVars");
        return parameters;
    }

    @Override
    public int getNumDataModels() {
        return this.dataSets.size();
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public static void topToBottomLayout(TimeLagGraph graph) {
        int xStart = 65;
        int yStart = 50;
        int xSpace = 100;
        int ySpace = 100;
        List<Node> lag0Nodes = graph.getLag0Nodes();
        lag0Nodes.sort(Comparator.comparingInt(Node::getCenterX));
        int x = -35;
        for (Node node : lag0Nodes) {
            x += 100;
            int y = -50;
            TimeLagGraph.NodeId id = graph.getNodeId(node);
            for (int lag = graph.getMaxLag(); lag >= 0; --lag) {
                y += 100;
                Node _node = graph.getNode(id.getName(), lag);
                if (_node == null) {
                    System.out.println("Couldn't find " + _node);
                    continue;
                }
                _node.setCenterX(x);
                _node.setCenterY(y);
            }
        }
    }
}

