/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.AncestorPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AncestorRecall;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;

public class AncestorF1
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "Ancestor-F1";
    }

    @Override
    public String getDescription() {
        return "F1 statistic for ancestry comparing the estimated graph to the true graph";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        double precision = new AncestorPrecision().getValue(trueGraph, estGraph, dataModel);
        double recall = new AncestorRecall().getValue(trueGraph, estGraph, dataModel);
        return 2.0 * (precision * recall) / (precision + recall);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

