/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.LatentCommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;

public class BidirectedLatentPrecision
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "<->-Lat-Prec";
    }

    @Override
    public String getDescription() {
        return "Percent of bidirected edges for which a latent confounder exists";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fp = 0;
        estGraph = GraphUtils.replaceNodes(estGraph, trueGraph.getNodes());
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            if (LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, edge)) {
                ++tp;
                continue;
            }
            ++fp;
        }
        return (double)tp / (double)(tp + fp);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

