/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;

public class CommonAncestorTruePositiveBidirected
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "CATPB";
    }

    @Override
    public String getDescription() {
        return "Common Ancestor True Positive Bidirected";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge) || !CommonAncestorTruePositiveBidirected.existsCommonAncestor(trueGraph, edge)) continue;
            ++tp;
        }
        return tp;
    }

    public static boolean existsCommonAncestor(Graph trueGraph, Edge edge) {
        for (Node c : trueGraph.getNodes()) {
            if (!trueGraph.paths().isAncestorOf(c, edge.getNode1()) || !trueGraph.paths().isAncestorOf(c, edge.getNode2())) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

