/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.CommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.LatentCommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.List;

public class CommonMeasuredAncestorRecallBidirected
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X<-M->Y,adj(X,Y),X<->Y";
    }

    @Override
    public String getDescription() {
        return "Number of X<~~M->...>Y for X*-*Y in est marked as bidirected";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fn = 0;
        List<Node> nodes = estGraph.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                Edge edge2;
                Node y;
                Node x = nodes.get(i);
                if (!CommonAncestorTruePositiveBidirected.existsCommonAncestor(trueGraph, Edges.nondirectedEdge(x, y = nodes.get(j))) || LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, Edges.nondirectedEdge(x, y)) || (edge2 = estGraph.getEdge(x, y)) == null) continue;
                if (Edges.isBidirectedEdge(edge2)) {
                    ++tp;
                    continue;
                }
                ++fn;
            }
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

