/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SearchGraphUtils;
import java.util.List;

public class DefiniteDirectedPathPrecision
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "DDPP";
    }

    @Override
    public String getDescription() {
        return "Proportion of DP(X, Y) in est for which DD(X, Y) in CPDAG(true)";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fp = 0;
        List<Node> nodes = trueGraph.getNodes();
        Graph cpdag = SearchGraphUtils.cpdagForDag(trueGraph);
        GraphUtils.addPagColoring(estGraph);
        for (Node x : nodes) {
            for (Node y : nodes) {
                Edge e;
                if (x == y || (e = estGraph.getEdge(x, y)) == null || !e.pointsTowards(y) || !e.getProperties().contains((Object)Edge.Property.dd)) continue;
                if (cpdag.paths().existsDirectedPathFromTo(x, y)) {
                    ++tp;
                    continue;
                }
                ++fp;
            }
        }
        return (double)tp / (double)(tp + fp);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

