/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SearchGraphUtils;
import java.util.List;

public class DefiniteDirectedPathRecall
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "DDPR";
    }

    @Override
    public String getDescription() {
        return "Proportion of DP(X, Y) in CPDAG(true) for which DP(X, Y) in est";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fn = 0;
        List<Node> nodes = trueGraph.getNodes();
        Graph cpdag = SearchGraphUtils.cpdagForDag(trueGraph);
        for (Node x : nodes) {
            for (Node y : nodes) {
                if (x == y || !cpdag.paths().existsDirectedPathFromTo(x, y)) continue;
                if (estGraph.paths().existsDirectedPathFromTo(x, y)) {
                    ++tp;
                    continue;
                }
                ++fn;
            }
        }
        return (double)tp / (double)(tp + fn);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

