/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.algcomparison.statistic.utils.AdjacencyConfusion;
import edu.cmu.tetrad.algcomparison.statistic.utils.ArrowConfusion;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;

public class F1All
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "F1All";
    }

    @Override
    public String getDescription() {
        return "F1 statistic for adjacencies and orientations combined";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        AdjacencyConfusion adjConfusion = new AdjacencyConfusion(trueGraph, estGraph);
        ArrowConfusion arrowConfusion = new ArrowConfusion(trueGraph, estGraph);
        int adjTp = adjConfusion.getTp();
        int adjFp = adjConfusion.getFp();
        int adjFn = adjConfusion.getFn();
        int adjTn = adjConfusion.getTn();
        int arrowTp = arrowConfusion.getTp();
        int arrowFp = arrowConfusion.getFp();
        int arrowFn = arrowConfusion.getFn();
        int arrowTn = arrowConfusion.getTn();
        double adjPrecision = (double)adjTp / (double)(adjTp + adjFp);
        double adjRecall = (double)adjTp / (double)(adjTp + adjFn);
        double arrowPrecision = (double)arrowTp / (double)(arrowTp + arrowFp);
        double arrowRecall = (double)arrowTp / (double)(arrowTp + arrowFn);
        return 4.0 * (adjPrecision * adjRecall * arrowPrecision * arrowRecall) / (adjPrecision + adjRecall + arrowPrecision + arrowRecall);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

