/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;

public class NoAlmostCyclicPathsCondition
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "NoAlmostCyclic";
    }

    @Override
    public String getDescription() {
        return "1 if the no almost cyclic paths condition passes, 0 if not";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        Graph pag = estGraph;
        for (Edge e : pag.getEdges()) {
            Node x = e.getNode1();
            Node y = e.getNode2();
            if (!Edges.isBidirectedEdge(e)) continue;
            if (pag.paths().existsDirectedPathFromTo(x, y)) {
                return 0.0;
            }
            if (!pag.paths().existsDirectedPathFromTo(y, x)) continue;
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

