/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SearchGraphUtils;
import java.util.List;

public class NoSemidirectedPrecision
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "NoSemidirected-Prec";
    }

    @Override
    public String getDescription() {
        return "Proportion of (X, Y) where if no semidirected path in est then also not in true";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fp = 0;
        Graph cpdag = SearchGraphUtils.cpdagForDag(trueGraph);
        List<Node> nodes = estGraph.getNodes();
        for (Node x : nodes) {
            for (Node y : nodes) {
                if (x == y || estGraph.paths().existsSemiDirectedPathFromTo(x, y)) continue;
                if (!cpdag.paths().existsSemiDirectedPathFromTo(x, y)) {
                    ++tp;
                    continue;
                }
                ++fp;
            }
        }
        return (double)tp / (double)(tp + fp);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

