/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import org.apache.commons.math3.util.FastMath;

public class NumAmbiguousTriples
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "AMB";
    }

    @Override
    public String getDescription() {
        return "Number of Ambiguous Triples";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        return estGraph.underlines().getAmbiguousTriples().size();
    }

    @Override
    public double getNormValue(double value) {
        return 1.0 - FastMath.tanh(value);
    }
}

