/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;

public class NumBidirectedBothNonancestorAncestor
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#<->,!Anc!Rev";
    }

    @Override
    public String getDescription() {
        return "# X<->Y for which both not X~~>Y and not Y~~>X";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int count = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            if (trueGraph.paths().isAncestorOf(x, y) || trueGraph.paths().isAncestorOf(y, x)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

