/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.LatentCommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SearchGraphUtils;

public class NumCompatibleDirectedEdgeConfounded
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#CompDConf";
    }

    @Override
    public String getDescription() {
        return "Number compatible X-->Y for which X and Y are confounded by a latent";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        GraphUtils.addPagColoring(estGraph);
        Graph pag = SearchGraphUtils.dagToPag(trueGraph);
        int tp = 0;
        int fp = 0;
        for (Edge edge : estGraph.getEdges()) {
            Edge trueEdge;
            if (!GraphUtils.compatible(edge, trueEdge = pag.getEdge(edge.getNode1(), edge.getNode2())) || !edge.getProperties().contains((Object)Edge.Property.dd) && !edge.getProperties().contains((Object)Edge.Property.pd)) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            if (LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, edge)) {
                ++tp;
                continue;
            }
            ++fp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

