/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.LatentCommonAncestorTruePositiveBidirected;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;

public class NumCompatibleDirectedEdgeNonAncestors
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#CompDNA";
    }

    @Override
    public String getDescription() {
        return "Number X-->Y for which not X<~~L->..->Y in true";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        GraphUtils.addPagColoring(estGraph);
        int tp = 0;
        int fp = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!edge.getProperties().contains((Object)Edge.Property.dd) && !edge.getProperties().contains((Object)Edge.Property.pd)) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            if (!trueGraph.paths().isAncestorOf(x, y) && !LatentCommonAncestorTruePositiveBidirected.existsLatentCommonAncestor(trueGraph, edge)) {
                ++tp;
                continue;
            }
            ++fp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

