/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.SearchGraphUtils;

public class NumCompatibleEdges
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#CE";
    }

    @Override
    public String getDescription() {
        return "Number compatible X*-*Y";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        GraphUtils.addPagColoring(estGraph);
        Graph pag = SearchGraphUtils.dagToPag(trueGraph);
        int tp = 0;
        int fp = 0;
        for (Edge edge : estGraph.getEdges()) {
            Edge trueEdge;
            if (GraphUtils.compatible(edge, trueEdge = pag.getEdge(edge.getNode1(), edge.getNode2()))) {
                ++tp;
                continue;
            }
            ++fp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

