/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SearchGraphUtils;

public class NumDefinitelyDirected
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X->Y-DefDir";
    }

    @Override
    public String getDescription() {
        return "Number of X-->Y in est where X~~>Y in true CPDAG";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int count = 0;
        Graph cpdag = SearchGraphUtils.cpdagForDag(trueGraph);
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isDirectedEdge(edge)) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            if (!cpdag.paths().isAncestorOf(x, y)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

