/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.HashSet;
import java.util.LinkedList;

public class NumDirectedEdgeNoMeasureAncestors
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X->Y-Anc-Direct";
    }

    @Override
    public String getDescription() {
        return "Number X-->Y for which X~~>Y in true with no measures on path";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        for (Edge edge : estGraph.getEdges()) {
            Node y;
            Node x;
            if (!Edges.isDirectedEdge(edge) || !this.existsDirectedPathFromTo(trueGraph, x = Edges.getDirectedEdgeTail(edge), y = Edges.getDirectedEdgeHead(edge))) continue;
            ++tp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }

    public boolean existsDirectedPathFromTo(Graph graph, Node node1, Node node2) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Q.add(node1);
        V.add(node1);
        while (!Q.isEmpty()) {
            Node t = (Node)Q.remove();
            for (Node c : graph.getChildren(t)) {
                if (c == node2) {
                    return true;
                }
                if (c.getNodeType() == NodeType.MEASURED || V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
            }
        }
        return false;
    }
}

