/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;

public class NumDirectedEdgeReversed
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "#X->Y-Rev";
    }

    @Override
    public String getDescription() {
        return "Number X-->Y for which Y~~>X in true";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        for (Edge edge : estGraph.getEdges()) {
            if (!Edges.isDirectedEdge(edge)) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            if (!trueGraph.paths().isAncestorOf(y, x)) continue;
            ++tp;
        }
        return tp;
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

