/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.SemidirectedPrecision;
import edu.cmu.tetrad.algcomparison.statistic.SemidirectedRecall;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;

public class SemidirectedPathF1
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "Semidirected-F1";
    }

    @Override
    public String getDescription() {
        return "F1 statistic for semidirected paths comparing the estimated graph to the true graph";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        double precision = new SemidirectedPrecision().getValue(trueGraph, estGraph, dataModel);
        double recall = new SemidirectedRecall().getValue(trueGraph, estGraph, dataModel);
        return 2.0 * (precision * recall) / (precision + recall);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

