/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.statistic;

import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.Collections;
import java.util.List;

public class SemidirectedPrecision
implements Statistic {
    static final long serialVersionUID = 23L;

    @Override
    public String getAbbreviation() {
        return "Semidirected-Prec";
    }

    @Override
    public String getDescription() {
        return "Proportion of (X, Y) where if semidirected path in est then also in true";
    }

    @Override
    public double getValue(Graph trueGraph, Graph estGraph, DataModel dataModel) {
        int tp = 0;
        int fp = 0;
        List<Node> nodes = estGraph.getNodes();
        nodes.removeIf(node -> node.getNodeType() == NodeType.LATENT);
        for (Node x : nodes) {
            for (Node y : nodes) {
                if (x == y || !estGraph.paths().existsSemiDirectedPathFromTo(x, Collections.singleton(y))) continue;
                if (trueGraph.paths().existsSemiDirectedPathFromTo(x, Collections.singleton(y))) {
                    ++tp;
                    continue;
                }
                ++fp;
            }
        }
        return (double)tp / (double)(tp + fp);
    }

    @Override
    public double getNormValue(double value) {
        return value;
    }
}

